import pyodbc

connection_string = 'DRIVER={SQLite3 ODBC Driver};SERVER=localhost;Trusted_connection=yes;DATABASE=D:\DataBase\Test.db'


def get_well_logs ():
  conn = pyodbc.connect(connection_string)
  cursor = conn.cursor()

  executing_string = 'SELECT DISTINCT LOG_NAME FROM WELL_LOGS'

  rows = cursor.execute (executing_string).fetchall ()

  well_logs = {str (row[0]) for row in rows}
  return list (well_logs)


def get_wells(well_log_name):
  conn = pyodbc.connect(connection_string)
  cursor = conn.cursor()

  executing_string = 'SELECT WELL_NAME FROM WELLS'

  rows = cursor.execute (executing_string).fetchall ()
  return [str (row[0]) for row in rows]


def get_args_vals_arrays (well_log_name, well_name):

    conn = pyodbc.connect(connection_string)
    cursor = conn.cursor()

    executing_string = 'SELECT WELL_NAME, LOG_VALUES FROM WELL_LOGS WHERE WELL_NAME = ? AND LOG_NAME = ?'

    row = cursor.execute (executing_string, well_name, well_log_name).fetchone ()
    well_id, log_values = row

    if not row:
        return None

    args = []
    vals = []

    if str(log_values) == "None":
      return None
  
    lines = log_values.split("\n")
    for line in lines:
        if len(line) > 0:
          lg_values = line.strip().split()
          args.append(float(lg_values[0]))
          vals.append(float(lg_values[1]))

    return [args, vals]