import pyodbc
from datetime import datetime

connection_string = 'DRIVER={SQLite3 ODBC Driver};SERVER=localhost;Trusted_connection=yes;DATABASE=D:\DataBase\Test.db'
first_date = datetime.strptime("01.01.1900", '%d.%m.%Y')

def get_prod_lines ():
    conn = pyodbc.connect(connection_string)
    cursor = conn.cursor()

    executing_string = 'SELECT ROWID, WELL_NAME, DATE, OIL_RATE, WATER_RATE FROM WELL_PRODUCTION'

    rows = cursor.execute (executing_string).fetchall()
    prod_lines = {}

    for row in rows:
        prod_lines[row[0]] = {}
        prod_lines[row[0]]["well"] = row[1]
        prod_lines[row[0]]["date"] = (datetime.strptime(row[2], '%d.%m.%Y') - first_date).days
        prod_lines[row[0]]["oil"]= float(row[3])
        prod_lines[row[0]]["water"]= float(row[4])

    wells = []
    dates = []
    values = []
    columns = ["oil", "water"]

    for line in prod_lines.values ():
        wells.append (line["well"])
        dates.append (line["date"])
        values.append ({key:line[key] for key in columns if key in line.keys ()})

    return [wells, dates, values]